@echo off
setlocal

set "input=results.csv"
set "output=medidas parede.csv"

REM ---------- FAILSAFE ----------
if not exist "%input%" (
    echo ERRO: O arquivo "%input%" nao foi encontrado.
    pause
    exit /b
)

if exist "%output%" (
    echo ERRO: "%output%" ja existe.
    echo Para evitar sobrescrever dados, o script foi interrompido.
    pause
    exit /b
)

REM ---------- RUN POWERSHELL ----------
powershell -NoLogo -NoProfile -Command ^
  "$csv = Import-Csv 'results.csv';" ^
  "$cols = $csv[0].psobject.Properties.Name;" ^
  "$idx = $cols[0];" ^
  "$measure = $cols | Where-Object {$_ -ne $idx} | Where-Object { ($csv[0].$_ -as [double]) -ne $null } | Select-Object -First 1;" ^
  "if(!$measure){Write-Host 'ERRO: Nenhuma coluna numerica encontrada.'; exit 1};" ^
  "$out = @(); for($i=0; $i -lt $csv.Count; $i+=2) {" ^
  "  if($i+1 -lt $csv.Count) {" ^
  "    $p = $csv[$i].$measure;" ^
  "    $d = $csv[$i+1].$measure;" ^
  "    $out += [pscustomobject]@{ parede=$p; dentro=$d };" ^
  "  }" ^
  "};" ^
  "$out | ForEach-Object { $_.parede = $_.parede -replace '\.', ','; $_.dentro = $_.dentro -replace '\.', ','; $_ } | Export-Csv 'medidas parede.csv' -NoTypeInformation -Delimiter ';' -Encoding UTF8"

echo.
echo OK! Arquivo gerado: "%output%"
pause
